//+------------------------------------------------------------------+
//|                                         smChaos TrendModeAll.mq4 |
//+------------------------------------------------------------------+
#property copyright "Copyright  2010.08.09 SwingMan"
#property link      ""

#property indicator_separate_window

#property indicator_buffers 8 
#property indicator_color1 MediumTurquoise
#property indicator_color2 Tomato //DeepPink //Magenta
#property indicator_color3 Gray
#property indicator_color4 MediumTurquoise
#property indicator_color5 Tomato //DeepPink //Magenta
#property indicator_color6 Gray
#property indicator_color7 Green //DarkOrange
#property indicator_color8 Red
/*#property indicator_color1 Green
#property indicator_color2 Red
#property indicator_color3 Gray
#property indicator_color4 Green
#property indicator_color5 Red
#property indicator_color6 Gray
#property indicator_color7 DeepPink //DarkOrange
#property indicator_color8 Blue*/

#property indicator_width1 3
#property indicator_width2 3
#property indicator_width3 1
#property indicator_width4 3
#property indicator_width5 3
#property indicator_width6 1
// signals
#property indicator_width7 1
#property indicator_width8 1

#property indicator_maximum 1
#property indicator_minimum -1
#property indicator_level1 0
#property indicator_levelstyle STYLE_SOLID
#property indicator_levelwidth 1

#define histValue 0.6

//---- input parameters 
extern int jaw_period=13; 
extern int jaw_shift =8; 
extern int teeth_period=8; 
extern int teeth_shift =5;
extern int lips_period=5; 
extern int lips_shift =3; 
extern int applied_price =PRICE_MEDIAN; 
extern int ma_method  = MODE_SMMA;
//---- buffers 
double UpTrend[], DnTrend[], NoTrend[]; 
double UpTrend2[], DnTrend2[], NoTrend2[]; 
double signalUP[],signalDN[];

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
{
   IndicatorShortName("SwingMan ChaosTrendMode (Alligator,AO,AC)");
   // histograms ....................................................
   SetIndexBuffer(0, UpTrend); 
   SetIndexBuffer(1, DnTrend); 
   SetIndexBuffer(2, NoTrend); 
   SetIndexBuffer(3, UpTrend2); 
   SetIndexBuffer(4, DnTrend2); 
   SetIndexBuffer(5, NoTrend2); 
    
   SetIndexStyle(0,DRAW_HISTOGRAM);
   SetIndexStyle(1,DRAW_HISTOGRAM);
   SetIndexStyle(2,DRAW_HISTOGRAM);
   SetIndexStyle(3,DRAW_HISTOGRAM);
   SetIndexStyle(4,DRAW_HISTOGRAM);
   SetIndexStyle(5,DRAW_HISTOGRAM);   
   
   SetIndexLabel(0,NULL); SetIndexLabel(1,NULL); SetIndexLabel(2,NULL);
   SetIndexLabel(3,NULL); SetIndexLabel(4,NULL); SetIndexLabel(5,NULL);
   /*SetIndexLabel(0,"Gator UP"); 
   SetIndexLabel(1,"Gator DOWN");
   SetIndexLabel(2,NULL);
   SetIndexLabel(3,"AOAC UP");
   SetIndexLabel(4,"AOAC DOWN");
   SetIndexLabel(5,NULL);*/
   
   // signals .......................................................
   int arrowUP=233;
   int arrowDN=234;
   //int arrowUP=217;//233
   //int arrowDN=218;//234
   SetIndexBuffer(6, signalUP); SetIndexStyle(6,DRAW_ARROW); SetIndexArrow(6,arrowUP);
   SetIndexBuffer(7, signalDN); SetIndexStyle(7,DRAW_ARROW); SetIndexArrow(7,arrowDN);
   
   SetIndexLabel(6,"Chaos UP");     
   SetIndexLabel(7,"Chaos DOWN");   
   
   IndicatorDigits(0);
   return(0);
}

//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
{
   return(0);
}

//####################################################################
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
{
   int limit;
   int counted_bars=IndicatorCounted();
   if(counted_bars<0) return(-1);
   if(counted_bars>0) counted_bars--;
   limit=Bars-counted_bars;

   //---- main loop
   for(int i=0; i<limit; i++)
   {
      UpTrend[i] = EMPTY_VALUE;
      DnTrend[i] = EMPTY_VALUE;
      NoTrend[i] = EMPTY_VALUE;
      UpTrend2[i] = EMPTY_VALUE;
      DnTrend2[i] = EMPTY_VALUE;
      NoTrend2[i] = EMPTY_VALUE;

               //*********************************      
               //    ALLIGATOR                   *
               //*********************************
      double blueLine  =  iAlligator(Symbol(),Period(), 
         jaw_period,jaw_shift,teeth_period,teeth_shift,lips_period,lips_shift,
         ma_method,applied_price,MODE_GATORJAW,i);
      double redLine  =  iAlligator(Symbol(),Period(), 
         jaw_period,jaw_shift,teeth_period,teeth_shift,lips_period,lips_shift,
         ma_method,applied_price,MODE_GATORTEETH,i);
      double greenLine  =  iAlligator(Symbol(),Period(), 
         jaw_period,jaw_shift,teeth_period,teeth_shift,lips_period,lips_shift,
         ma_method,applied_price,MODE_GATORLIPS,i);
      
      bool Cond_Long  = (greenLine>redLine && redLine>blueLine);                        
      bool Cond_Short = (greenLine<redLine && redLine<blueLine);
                            
      // ALLIGATOR Trend Long ---------------------------------------
      if (Cond_Long)
         UpTrend[i] = histValue;
      else         
      // ALLIGATOR Trend Short --------------------------------------
      if (Cond_Short)
         DnTrend[i] = histValue;
      else
      // no Trend ----------------------------------------------
      NoTrend[i] = histValue;
      
      
               //*********************************      
               //    AO & AC                     *
               //*********************************
      double AO_Line0  =  iAO(Symbol(),Period(),i);
      double AO_Line1  =  iAO(Symbol(),Period(),i+1);
      double AC_Line0  =  iAC(Symbol(),Period(),i);
      double AC_Line1  =  iAC(Symbol(),Period(),i+1);
      
      int idxAO = 0;
      if (AO_Line0 > AO_Line1) idxAO = 1; else
      if (AO_Line0 < AO_Line1) idxAO = -1;
      
      int idxAC = 0;
      if (AC_Line0 > AC_Line1) idxAC = 1; else
      if (AC_Line0 < AC_Line1) idxAC = -1;
      
      bool Cond_Long2  = (idxAO==1 && idxAC==1);
      bool Cond_Short2 = (idxAO==-1 && idxAC==-1);
                            
      // ALLIGATOR Trend Long ---------------------------------------
      if (Cond_Long2)
         UpTrend2[i] = -histValue;
      else         
      // ALLIGATOR Trend Short --------------------------------------
      if (Cond_Short2)
         DnTrend2[i] = -histValue;
      else
      // no Trend ----------------------------------------------
      NoTrend2[i] = -histValue;      
      
               //*********************************      
               //    SIGNALS                     *
               //*********************************      
      signalUP[i] = EMPTY_VALUE;
      signalDN[i] = EMPTY_VALUE;
      if (Cond_Long && Cond_Long2)   signalUP[i] = 0; else
      if (Cond_Short && Cond_Short2) signalDN[i] = 0;
   }
//----
   return(0);
}
//+------------------------------------------------------------------+